package cmr;

import java.rmi.RemoteException;
import javax.ejb.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;

public abstract class ItemBean implements EntityBean{


	//CMPtB[h
	public abstract String getId();
	public abstract void setId(String id);
	
	public abstract String getName();
	public abstract void setName(String name);
	
	
	//CMRtB[h	
	public abstract Stock getStock();
	public abstract void setStock(Stock stock);
	public abstract Stock ejbSelectStock(String id) throws FinderException;

	
	
	
	public String ejbCreate(String id) throws CreateException{
		setId(id);
		return null;
	}
	
	
	public String ejbCreate(String id, String name) throws CreateException{
		setId(id);
		setName(name);
		return null;
	}
	
	public void ejbPostCreate(String id) throws CreateException{
		try{
			InitialContext ctx = new InitialContext();
			StockHome home = (StockHome)ctx.lookup("java:comp/env/ejb/StockEJB");
			Stock stock = home.create(id, 100);
			setStock(stock);
		}catch(Exception e){
			throw new EJBException(e);
		}

//		try{
//			Stock stock = ejbSelectStock(id);
//			System.out.println("ejbSelectStock : " + stock);
//		}catch(Exception e){
//			e.printStackTrace();
//			throw new EJBException(e);
//		}
	}

	public void ejbPostCreate(String id, String name) throws CreateException{
		ejbPostCreate(id);
	}




	public int getStockCount() {
		return getStock().getStock();
	};

	public void setStockCount(int count) {
		getStock().setStock(count);
	};





	/**
	 * @see javax.ejb.EntityBean#ejbActivate()
	 */
	public void ejbActivate() throws EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#ejbLoad()
	 */
	public void ejbLoad() throws EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#ejbPassivate()
	 */
	public void ejbPassivate() throws EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#ejbRemove()
	 */
	public void ejbRemove()
		throws RemoveException, EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#ejbStore()
	 */
	public void ejbStore() throws EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#setEntityContext(EntityContext)
	 */
	public void setEntityContext(EntityContext arg0)
		throws EJBException, RemoteException {
	}

	/**
	 * @see javax.ejb.EntityBean#unsetEntityContext()
	 */
	public void unsetEntityContext() throws EJBException, RemoteException {
	}

}
